//+------------------------------------------------------------------+
//|                                                 Put_Market_Order |
//|                                                          ARGOLab |
//|                                                                  |
//+------------------------------------------------------------------+
#property link "http://www.argolab.net/"
#property copyright " ARGOLab"

#property show_inputs

extern int Direction = 0;
extern int StopLossPips = 0;
extern int TakeProfitPips = 0;
extern double StopLoss = 0;
extern double TakeProfit = 0;
extern double LotSize = 0.1;
extern int Magic = 11111;
extern string comment = "11111";

int slippage = 3;

//---   
double MinLot;
double MaxLot;
double LotStep;
int LotDigits;

//
//----
//
int start()  {
   double stop_level = MarketInfo(Symbol(),MODE_STOPLEVEL)*Point;
   double point4;
   int nAttempts = 5;
   int i;
   int ticket;
   bool res=FALSE;
   int Otype;
   double OP;
   double OSL,OTP;
   
       //
   if (Direction == 0) {
      Alert("Direction should not be zero!");
      return(0);
   }

      //
   if (Digits < 4) {
      point4 = 0.01;
   } else {
      point4 = 0.0001;
   }
   MinLot = MarketInfo(Symbol(), MODE_MINLOT);
   MaxLot = MarketInfo(Symbol(), MODE_MAXLOT);
   LotStep = MarketInfo(Symbol(), MODE_LOTSTEP);
   if (LotStep < 0.1) {
      LotDigits = 2;
   } else if (LotStep < 1) {
      LotDigits = 1;
   } else {
      LotDigits = 0;
   }

        //
   for (i = 1; i <= nAttempts; i++) {
      if (Direction > 0) {
         ticket = OrderSend(Symbol(),OP_BUY, NL(LotSize), ND(Ask), slippage, 0, 0, comment, Magic, 0, Blue);
      } else if (Direction < 0) {
         ticket = OrderSend(Symbol(),OP_SELL, NL(LotSize), ND(Bid), slippage, 0, 0, comment, Magic, 0, Red);
      }
      if (ticket > 0) {
         Alert("The order was put");
         break;
      }
      HandleError();
   }

       //
   if (OrderSelect(ticket,SELECT_BY_TICKET)) {
      Otype = OrderType();
      OP = OrderOpenPrice();
      OSL = 0;
      OTP = 0;
      if (Direction > 0) {
         if (StopLossPips > 0) OSL = OP - StopLossPips*point4;
         if (TakeProfitPips > 0) OTP = OP + TakeProfitPips*point4;
      } else {
         if (StopLossPips > 0) OSL = OP + StopLossPips*point4;
         if (TakeProfitPips > 0) OTP = OP - TakeProfitPips*point4;
      }
      if (StopLoss > 0) OSL = StopLoss;
      if (TakeProfit > 0) OTP = TakeProfit;
      if (OSL > 0 || OTP > 0) {
        for (i = 1; i <= nAttempts; i++) {
            if (Otype == OP_BUY) {
               res = OrderModify(ticket, OP, ND(OSL), ND(OTP), 0, Blue);
            } else if (Otype == OP_SELL) {
               res = OrderModify(ticket, OP, ND(OSL), ND(OTP), 0, Red);
            }
            if (res) {
               Alert("The stop levels are set");
               break;
            }
            HandleError();
         }
         if (!res) {
            Alert("The stop levels are NOT set");
         }
      }
   }       
   return(0);
}
//+------------------------------------------------------------------+


double ND(double np) {
  return(NormalizeDouble(np,Digits));
}


double NL(double lot_) {
   double lot = NormalizeDouble(MathRound(lot_/LotStep)*LotStep,LotDigits);
   if (lot < MinLot) lot = MinLot;
   if (lot > MaxLot) lot = MaxLot;
   return(lot);
}


int HandleError() {
   int error_0 = GetLastError();
   Print("ERROR (" + error_0 + ") : " + error(error_0));
   if (error_0 == 130/* INVALID_STOPS */ || error_0 == 129/* INVALID_PRICE */ || error_0 == 138/* REQUOTE */ || error_0 == 135/* PRICE_CHANGED */ || error_0 == 136/* OFF_QUOTES */) {
      RefreshRates();
      return (1);
   }
   if (error_0 == 146/* TRADE_CONTEXT_BUSY */ || error_0 == 133/* TRADE_DISABLED */ || error_0 == 128/* TRADE_TIMEOUT */ || error_0 == 139/* ORDER_LOCKED */) {
      Sleep(500);
      RefreshRates();
      return (1);
   }
   if (error_0 == 4/* SERVER_BUSY */ || error_0 == 137/* BROKER_BUSY */ || error_0 == 4022/* SYSTEM_BUSY */ || error_0 == 6/* NO_CONNECTION */ || error_0 == 141/* TOO_MANY_REQUESTS */ ||
      error_0 == 8/* TOO_FREQUENT_REQUESTS */) {
      Sleep(1500);
      RefreshRates();
      return (1);
   }
   if (error_0 == 147/* TRADE_EXPIRATION_DENIED */) {
      RefreshRates();
      return (1);
   }
   if (error_0 != 0/* NO_ERROR */) {
      Sleep(500);
      RefreshRates();
      return (0);
   }
   return (0);
}

//---
string error(int eer)
{
   string er;
   switch(eer)
     {
      //---- 
      case 0:
      case 1:   er="no error";                         break;
      case 2:   er="common error";                                                break;
      case 3:   er="invalid trade parameters";                                      break;
      case 4:   er="trade server is busy";                                       break;
      case 5:   er="old version of the client terminal";                         break;
      case 6:   er="no connection with trade server";                               break;
      case 7:   er="not enough rights";                                           break;
      case 8:   er="too frequent requests";                                      break;
      case 9:   er="malfunctional trade operation";   break;
      case 64:  er="account disabled";                                           break;
      case 65:  er="invalid account";                                    break;
      case 128: er="trade timeout";                       break;
      case 129: er="invalid price";                                           break;
      case 130: er="invalid stops";                                          break;
      case 131: er="invalid trade volume";                                          break;
      case 132: er="market is closed";                                                break;
      case 133: er="trade is disabled";                                          break;
      case 134: er="not enough money";                  break;
      case 135: er="price changed";                                             break;
      case 136: er="off quotes";                                                     break;
      case 137: er="broker is busy";                                                break;
      case 138: er="requote";                                         break;
      case 139: er="order is locked";                     break;
      case 140: er="long positions only allowed";                                    break;
      case 141: er="too many requests";                                      break;
      case 145: er="modification denied because order too close to market"; break;
      case 146: er="trade context is busy";                                  break;
      case 147: er="expiration date is not supported";      break;
      case 148: er="maximal number of open orders is reached ";  break;
      //---- 
      case 4105: er="no order selected";                                    break;
      case 4106: er="unknown symbol";                                         break;
      case 4107: er="invalid price parameter for trade function";            break;
      case 4108: er="invalid ticket";                                      break;
      case 4109: er="trade is not allowed";                                      break;
      case 4110: er="longs are not allowed";                               break;
      case 4111: er="shorts are not allowed";                              break;
      default:   er="unknown error";
     }
  return(er);
}


